/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;

public class ChoiceCellEditor
extends Choice
implements CellEditor,
ItemListener,
KeyListener {
    protected int firstSelection;
    protected int newSelection;
    protected CellEditorSupport support = new CellEditorSupport();
    protected int[] values;
    protected boolean ignoreEnterKey = false;

    public ChoiceCellEditor() {
        this.values = null;
    }

    public ChoiceCellEditor(String[] stringArray) {
        this(stringArray, null);
    }

    public ChoiceCellEditor(String[] stringArray, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addItem(stringArray[n]);
            ++n;
        }
        this.values = nArray;
        this.addItemListener(this);
        this.addKeyListener(this);
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        if (initialEvent.getEventType() == 2 && initialEvent.getKey() == 10) {
            this.ignoreEnterKey = true;
        }
        if (object instanceof Number) {
            this.firstSelection = this.newSelection = this.getIndexFromValue(((Number)object).intValue());
        }
        this.select(this.newSelection);
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        return new Integer(this.values[this.newSelection]);
    }

    public boolean isModified() {
        return this.firstSelection != this.newSelection;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return this.getComponent().preferredSize();
    }

    public KeyModifier[] getReservedKeys() {
        return null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.newSelection = this.getSelectedIndex();
        this.support.fireStopEditing(new CellEditorEvent(itemEvent));
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.support.fireStopEditing(new CellEditorEvent(keyEvent));
        } else if (keyEvent.getKeyCode() == 10 && !this.ignoreEnterKey) {
            this.support.fireStopEditing(new CellEditorEvent(keyEvent));
        }
        this.ignoreEnterKey = false;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    private int getIndexFromValue(int n) {
        if (this.values == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.values.length) {
            if (this.values[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

